<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PaperAnswers extends Model 
{

    protected $table = 'paper_answers';
    public $timestamps = true;

    public function question()
    {
        return $this->belongsTo('App\Models\Question');
    }

    public function answer()
    {
        return $this->belongsTo('App\Models\QuestionChoice', 'answer_id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function task()
    {
        return $this->belongsTo('App\Models\Task');
    }

}